#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Deep;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'tmp' => 'id:pk', ':st SET("st", "st1", "st2")');
my @rows;
sub _check_all {
    my @real_rows = map {[$_->{id}, $_->{st}]} @{get_all_sql(UT, "select id, st from tmp")};
    cmp_deeply(\@real_rows, bag(@rows), @_);
}


# insert __sset => hashref
do_insert_into_table(UNIT_TESTS, "tmp", {id => 1, st__sset => {st=>1}});
push @rows, [1, 'st'];
_check_all('insert __sset => hashref');

do_insert_into_table(UNIT_TESTS, "tmp", {id => 2, st__sset => {st => 1, st1=>0, st2=>1, st3=>1}});
push @rows, [2, 'st,st2'];
_check_all();

do_insert_into_table(UNIT_TESTS, "tmp", {id => 3, st__sset => {}});
push @rows, [3, ''];
_check_all();


@rows = (); do_sql(UT, "TRUNCATE TABLE tmp");


# insert __sset => arrayref
do_insert_into_table(UNIT_TESTS, "tmp", {id => 1, st__sset => ['st']});
push @rows, [1, 'st'];
_check_all('insert __sset => arrayref');

do_insert_into_table(UNIT_TESTS, "tmp", {id => 2, st__sset => ['st', 'st2', 'st3']});
push @rows, [2, 'st,st2'];
_check_all();

do_insert_into_table(UNIT_TESTS, "tmp", {id => 3, st__sset => []});
push @rows, [3, ''];
_check_all();


# insert __smod => hashref
do_insert_into_table(UNIT_TESTS, "tmp", {id => 4, st__smod => {st=>1}}, on_duplicate_key_update => 1);
push @rows, [4, 'st'];
_check_all('insert __smod => hashref, on_duplicate_key_update');

do_insert_into_table(UNIT_TESTS, "tmp", {id => 4, st__smod => {st=>1}}, on_duplicate_key_update => 1);
_check_all();

do_insert_into_table(UNIT_TESTS, "tmp", {id => 4, st__smod => {st=>0}}, on_duplicate_key_update => 1);
$rows[-1][1] = '';
_check_all();

do_insert_into_table(UNIT_TESTS, "tmp", {id => 4, st__smod => {st1=>1, st2=>1}}, on_duplicate_key_update => 1);
$rows[-1][1] = 'st1,st2';
_check_all();

do_insert_into_table(UNIT_TESTS, "tmp", {id => 4, st__smod => {st2=>0}}, on_duplicate_key_update => 1);
$rows[-1][1] = 'st1';
_check_all();


# update __sset
do_update_table(UNIT_TESTS, "tmp", {st__sset => {st => 0, st1=>1}}, where => {id => 2});
$rows[1][1] = 'st1';
_check_all('update __sset');

do_update_table(UNIT_TESTS, "tmp", {st__sset => ['st', 'st1']}, where => {id => 2});
$rows[1][1] = 'st,st1';
_check_all();


# update smod
do_update_table(UNIT_TESTS, "tmp", {st__smod => {}}, where => {id => 2});
_check_all('update __smod');

do_update_table(UNIT_TESTS, "tmp", {st__smod => {st => 0}}, where => {id => 2});
$rows[1][1] = 'st1';
_check_all();

do_update_table(UNIT_TESTS, "tmp", {st__smod => {st => 1, st1 => 0, st2 => 1}}, where => {id => 2});
$rows[1][1] = 'st,st2';
_check_all();

# на данный момент
# 1 'st'
# 2 'st,st2'
# 3 ''
is(get_one_field_sql(UT, ["SELECT id FROM tmp", where => {st__scheck => {st => 0}}]), 3, 'scheck');
is(get_one_field_sql(UT, ["SELECT id FROM tmp", where => {st__scheck => {st2 => 1}}]), 2, 'scheck');
is(get_one_field_sql(UT, ["SELECT id FROM tmp", where => {st__scheck => {st2 => 1, st => 1}}]), 2, 'scheck');
is(get_one_field_sql(UT, ["SELECT id FROM tmp", where => {st__scheck => {st2 => 1, st3 => 1}}]), undef, 'scheck');
is(get_one_field_sql(UT, ["SELECT count(*) FROM tmp", where => {st__scheck => {}}]), 4, 'scheck');


done_testing;

1;
