#!/usr/bin/perl -w

=pod

    $Id: exec_sql.t 2300 2013-06-13 12:26:29Z zhur $

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

######################
# tests for sharded db

do_sql(SHUT(shard => 'all'), "CREATE TABLE sfr (i int)");
do_insert_into_table(SHUT_1, "sfr", {i => 1});
do_insert_into_table(SHUT_1, "sfr", {i => 2});

do_insert_into_table(SHUT_2, "sfr", {i => 1});
do_insert_into_table(SHUT_2, "sfr", {i => 4});
do_insert_into_table(SHUT_2, "sfr", {i => 5});

# Базовая проверка, что работает все как ожидается
get_all_sql(SHUT(shard => 'all'), "SELECT SQL_CALC_FOUND_ROWS * FROM sfr");
is(select_found_rows(SHUT(shard => 'all')), 5);

# Значение из нескольких шардов
get_all_sql(SHUT(shard => 'all'), "SELECT SQL_CALC_FOUND_ROWS * FROM sfr WHERE i=?",1);
is(select_found_rows(SHUT(shard => 'all')), 2);

# Была выборка из нескольких шардов с использованием limit
get_all_sql(SHUT(shard => 'all'), "SELECT SQL_CALC_FOUND_ROWS * FROM sfr WHERE i<? LIMIT 2",3);
is(select_found_rows(SHUT(shard => 'all')), 3);

# Все значения были выбраны только из одного шарда, во втором не нашлось
get_all_sql(SHUT(shard => 'all'), "SELECT SQL_CALC_FOUND_ROWS * FROM sfr WHERE i>?",3);
is(select_found_rows(SHUT(shard => 'all')), 2);

#  Используем один шард
get_all_sql(SHUT(shard => 1), "SELECT SQL_CALC_FOUND_ROWS * FROM sfr WHERE i>?",3);
is(select_found_rows(SHUT(shard => 1)), 0);

#  Используем несколько шардов с принудительными значениями и лимитом
get_all_sql(SHUT(shard => [1, 2]), "SELECT SQL_CALC_FOUND_ROWS * FROM sfr WHERE i<? LIMIT 2",5);
is(select_found_rows(SHUT(shard => [1, 2])), 4);

is(select_found_rows(SHUT(shard => [])), 0);

# Удаляем таблицу, чтобы она в других тестах не мешалась.
do_delete_from_table(SHUT(shard => 'all'), "sfr");

done_testing();

1;
