#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::Exception;
use Test::More;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

*sc = \&Yandex::DBTools::sql_condition;

my $f;

note('using sql_condition without specified $dbh');
{
    local $Yandex::DBTools::QUOTE_DB = 'ut';

    $f = sc( { cid => 1, bid => 2 } );
    is( $f, "`bid` ='2' AND `cid` ='1'", 'default AND' );

    $f = sc( { cid => 1, bid => 2 }, operation => 'OR' );
    is( $f, "`bid` ='2' OR `cid` ='1'", 'OR' );

    $f = sc( { cid => 1, _OR => { bid => 2, oid => 3 }, } );
    is( $f, "(`bid` ='2' OR `oid` ='3') AND `cid` ='1'", 'recursive with OR' );

    $f = sc( { cid => 1, _OR => [ bid__le => 2, bid__gt => 3 ], } );
    is( $f, "(`bid` <='2' OR `bid` >'3') AND `cid` ='1'", 'recursive with arrayref' );

    $f = sc( { cid => 1, _OR => [ bid__le => 2, bid__gt => 3, r => sub {return [1,2,3]} ], } );
    is( $f, "(`bid` <='2' OR `bid` >'3' OR `r` IN ('1','2','3')) AND `cid` ='1'" );

    $f = sc( { cid => 1, _OR => [ bid__le => 2, bid__gt => 3, r => sub {return "fe"} ], } );
    is( $f, "(`bid` <='2' OR `bid` >'3' OR `r` ='fe') AND `cid` ='1'" );

    $f = sc( { cid => 1, _OR => [ bid__le => 2, bid__gt => 3, r => sub {return shift} ], }, params => 42 );
    is( $f, "(`bid` <='2' OR `bid` >'3' OR `r` ='42') AND `cid` ='1'" );

    $f = sc( { cid => 1, _NOT => { bid => 2 } });
    is( $f, "NOT (`bid` ='2') AND `cid` ='1'", 'NOT with one field');

    my $r = "NOT (`bid` ='2' AND `pid` ='3') AND `cid` ='1'";
    $f = sc( { cid => 1, _NOT => { bid => 2, pid => 3} });
    is( $f, $r, 'NOT with two fields');
    $f = sc( { cid => 1, _NOT => [ bid => 2, pid => 3] });
    is( $f, $r, 'NOT with arrayref');

    $r = "NOT ((`cids_cnt` >'5' OR `phrases_cnt` >'200')) AND `cid` ='1'";
    $f = sc( { cid => 1, _NOT => { _OR => [ cids_cnt__gt => 5, phrases_cnt__gt => 200 ] } });
    is( $f, $r, 'NOT with OR arrayref');
    $f = sc( { cid => 1, _NOT => { _OR => { cids_cnt__gt => 5, phrases_cnt__gt => 200 } } });
    is( $f, $r, 'NOT with OR hashref');
    
    $f = sc( { 'name__contains__collate(utf8_bin)' => 'xyz' } );
    is( $f, "`name` LIKE '%xyz%' COLLATE 'utf8_bin'", 'COLLATE' );
}

note ('DEPRECATED');
my $dbh = get_dbh(UT);

$f = sc( UT, { cid => 1, bid => 2 } );
is( $f, "`bid` ='2' AND `cid` ='1'", 'default AND' );

$f = sc( UT, { cid => 1, bid => 2 }, operation => 'OR' );
is( $f, "`bid` ='2' OR `cid` ='1'", 'OR' );

$f = sc( $dbh, { cid => 1, _OR => { bid => 2, oid => 3 }, } );
is( $f, "(`bid` ='2' OR `oid` ='3') AND `cid` ='1'", 'recursive with OR' );

$f = sc( $dbh, { cid => 1, _OR => [ bid__le => 2, bid__gt => 3 ], } );
is( $f, "(`bid` <='2' OR `bid` >'3') AND `cid` ='1'", 'recursive with arrayref' );

$f = sc( $dbh, { cid => 1, _OR => [ bid__le => 2, bid__gt => 3, r => sub {return [1,2,3]} ], } );
is( $f, "(`bid` <='2' OR `bid` >'3' OR `r` IN ('1','2','3')) AND `cid` ='1'" );

$f = sc( $dbh, { cid => 1, _OR => [ bid__le => 2, bid__gt => 3, r => sub {return "fe"} ], } );
is( $f, "(`bid` <='2' OR `bid` >'3' OR `r` ='fe') AND `cid` ='1'" );

# __int modifier
$f = sc({ cid__int => 123 } );
is( $f, "`cid` =123" );
$f = sc({ cid__int => -123 } );
is( $f, "`cid` =-123" );
$f = sc( { cid__int => [] } );
is( $f, "0" );
$f = sc( { cid__int => [undef, undef] } );
is( $f, "0" );
$f = sc({ cid__int => [123,-123] } );
is( $f, "`cid` IN (123,-123)" );
$f = sc({ cid__int => [123,undef,-123] } );
is( $f, "`cid` IN (123,-123)" );

dies_ok { sc({ cid__int => 'asdf' } ) };
dies_ok { sc({ cid__int => [123, 'asdf'] } ) };

done_testing();
