#!/usr/bin/perl
use strict;
use warnings;

use Test::Exception;
use Test::More tests => 7;

use Yandex::DBTools;
use Yandex::DBUnitTest;

$Yandex::DBTools::QUOTE_DB = 'unit_tests';

throws_ok { sql_fields() } qr{Missing parameter: fields}, 'empty field list';

is( sql_fields('foo'), '`foo`', 'foo' );
is( sql_fields('foo.bar'), '`foo`.`bar`', 'foo.bar' );
is( sql_fields( 'foo.bar', 'baz' ), '`foo`.`bar`,`baz`', 'foo.bar, baz' );
is( sql_fields( 'foo', 'bar.baz' ), '`foo`,`bar`.`baz`', 'foo, bar.baz' );
is( sql_fields( 'foo.bar', 'baz.quux' ), '`foo`.`bar`,`baz`.`quux`', 'foo.bar, baz.quux' );

dies_ok { sql_fields( 'foo', '' ) } "foo + an empty argument";
