#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use List::Util qw/max/;
use Test::More;
use Test::Exception;

use Yandex::DBTools;
require Yandex::DBUnitTest;
$Yandex::DBTools::QUOTE_DB = 'unit_tests';

*f = \&Yandex::DBTools::sql_mass_inserts;

for my $l (100, 1000, 10000) {
    my $sqls = f("insert into xxx values %s", [(["x" x 10, 12, 234]) x 1e5], {desired_sql_length => $l});
    my $max_sql_len = max(map {length} @$sqls);
    ok($max_sql_len < $l);
    ok($max_sql_len > $l / 2);
}

$Yandex::DBTools::QUOTE_DB = undef;
dies_ok { f("insert into xxx values %s", [["x", 12, 234]]) } "no global quote db";
lives_ok { f("insert into xxx values %s", [["x", 12, 234]], {quote_db => 'unit_tests'}) } "no global quote db, but quote_db in opts";
dies_ok { f("insert into xxx values %s", [["x", 12, 234]], {quote_db => 'unit_testSSS'}) } "no global quote db, bad quote_db in opts";

done_testing;
