#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::DBTools;

sub sq {
    return Yandex::DBTools::sql_quote($_[0]);
}

dies_ok {sq("")};
$Yandex::DBTools::QUOTE_DB = 'asdf';
dies_ok {sq("")};

$Yandex::DBTools::QUOTE_DB = 'unit_tests';
require Yandex::DBUnitTest;
lives_ok {sq("")};

is(sq(""), q!''!);
is(sq(undef), q!NULL!);
is(sq(123), q!'123'!);
is(sq("\"\\"), q!'\"\\\\'!);

done_testing();

