#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::DBTools;

sub sqi {
    return Yandex::DBTools::sql_quote_identifier($_[0]);
}

dies_ok {sqi("")};
$Yandex::DBTools::QUOTE_DB = 'asdf';
dies_ok {sqi("")};

$Yandex::DBTools::QUOTE_DB = 'unit_tests';
require Yandex::DBUnitTest;
lives_ok {sqi("")};

is(sqi(""), q!``!);
is(sqi(undef), q!!);
is(sqi(123), q!`123`!);
is(sqi("asdfqewr"), q!`asdfqewr`!);
is(sqi("as.dfqe.wr"), q!`as`.`dfqe`.`wr`!);

done_testing();

