#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Yandex::DBTools qw/sql_quote_like_pattern/;

my %tests = (
    # $pattern => $expected_quoted_pattern
    '' => '',
    'holodilnikru' => 'holodilnikru',
    '%holo_dilnik__%' => '\%holo\_dilnik\_\_\%',
    'UR_ur/ur.xednay%' => 'UR\_ur/ur.xednay\%',
    'A:\test%.txt' => 'A:\\\\test\%.txt',
    '\%' => '\\\\\%',
);

Test::More::plan(tests => scalar(keys %tests));

while (my ($pattern, $expected_quoted_pattern) = each %tests) {
    my $quoted_pattern = sql_quote_like_pattern($pattern);
    my $test_name = "sql_quote_like_patter('$pattern')";
    is($quoted_pattern, $expected_quoted_pattern, $test_name);
}
