#!/usr/bin/perl -w

# $Id$

=head1 DBUnitTest.t

    Юнит-тесты модуля для юнит-тестов.
    Звучит странно, но проверить что всё работает как задумано - никогда не бывает лишним.
    Можно воспринимать этот тест как примеры разных кейсов для:
        %dataset, описывающего содержимое баз данных
        &init_test_dataset - создающей таблицы и заполняющей их данными
        &replace_test_data - заменяющей в одной(!) таблице (но во всех шардах) данные на заданные
        &check_test_dataset - проверяющей, что все содержимое %dataset действительно существует в правильных базах/шардах

=cut

use strict;
use warnings;

use Test::More tests => 7;
use Test::Deep;
use Test::Exception;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

####################################################################
##### Нулевая группа тестов - проверка, что с шардингом всё ок #####
####################################################################
ok(!Yandex::DBUnitTest::_is_sharded(UT), q/UT isn't sharded/);
dies_ok {
    local $Yandex::DBUnitTest::SHARDED_DB_RE = qr/unit_tests/;
    Yandex::DBUnitTest::_is_sharded(UT);
} 'Marking database UT as sharded is not allowed';
ok(Yandex::DBUnitTest::_is_sharded(SHUT(shard => 'all')), q/SHUT(shard => all) is sharded/);
ok(Yandex::DBUnitTest::_is_sharded(SHUT(shard => 1)), q/SHUT(shard => 1) is sharded/);
ok(Yandex::DBUnitTest::_is_sharded(SHUT(shard => 2)), q/SHUT(shard => 2) is sharded/);
ok(Yandex::DBUnitTest::_is_sharded(SHUT_1), q/SHUT_1 is sharded/);
ok(Yandex::DBUnitTest::_is_sharded(SHUT_2), q/SHUT_2 is sharded/);
