package Model::Base::DefineFields;

use strict;
use warnings;
use utf8;

sub by_types {
    my ($meta, %fields_by_type) = @_;
    foreach my $type (keys %fields_by_type) {
        foreach my $attr ( @{$fields_by_type{$type}} ) {
            $meta->add_attribute(
                $attr,
                is => 'ro',
                isa => $type,
                lazy_build => 1
            );
            if ($type eq 'Flag') {
                $meta->add_method(
                    "${attr}_yesno" => sub {
                        my $self = shift;
                        $self->yesno($self->$attr)
                    }
                );
            }
            if ($type eq 'Timestamp') {
                $meta->add_method(
                    "${attr}_short" => sub {
                        my $self = shift;
                        $self->trim_timestamp($self->$attr)
                    }
                );
            }
        }
    }
    return;
}

1;

