package Model::Base::Relations;

use strict;
use warnings;
use utf8;

use Module::Load;

our @METHODS = qw/belongs_to has_many has_one _has_type/;

use Mouse::Exporter;

use Model::Base::DefineFields;

Mouse::Exporter->setup_import_methods(
    as_is => [
        @METHODS
    ]
);

sub belongs_to { # belongs_to campaign => "Model::Mapper::Campaigns" by 'cid'
    return _has_type(caller->meta, 0, @_)
}

sub has_many { # has_many groups => 'Model::Mapper::AdGroups' by 'cid';
    return _has_type(caller->meta, 1, @_)
}

sub has_one {# has_one address => 'Model::Mapper::Addresses' by 'vcard_id';
    return _has_type(caller->meta, 0, @_)
}

sub _has_type {
    my ($meta, $is_many, $by_field, $to_model) = @_;

    my $field_type = $is_many
        ? "ArrayRef\[$to_model\]"
        : "Maybe\[$to_model\]";

    Model::Base::DefineFields::by_types(
        $meta,
        $field_type => [ $by_field ]
    );



    load $to_model;

    no strict 'refs';
    my $name = $meta->name;
    ${"$name\::_LINKS"} //= {};
    ${"$name\::_LINKS"}->{$by_field} = $to_model;

    return;
}

1;
