package Model::Base::Types;

use Mouse;
use Mouse::Util::TypeConstraints;

my $TIMESTAMP_RE = qr/^(((\d{4})(-)(0[13578]|10|12)(-)(0[1-9]|[12][0-9]|3[01]))|((\d{4})(-)(0[469]|11)(-)([0][1-9]|[12][0-9]|30))|((\d{4})(-)(02)(-)(0[1-9]|1[0-9]|2[0-8]))|(([02468][048]00)(-)(02)(-)(29))|(([13579][26]00)(-)(02)(-)(29))|(([0-9][0-9][0][48])(-)(02)(-)(29))|(([0-9][0-9][2468][048])(-)(02)(-)(29))|(([0-9][0-9][13579][26])(-)(02)(-)(29)))(\s([0-1][0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9]))$/;

subtype 'Number' => as 'Num';
subtype 'UnsignedInt' => as 'Int' => where { $_ >= 0 };
subtype 'UnsignedNumber'  => as 'Number' => where { $_ >= 0 };
subtype 'Id' => as 'UnsignedInt';
subtype 'Id32' => as 'UnsignedInt' => where { $_ <= 4294967295 }; # 2^32
subtype 'Id64' => as 'UnsignedInt' => where { $_ <= 18446744073709551615 }; # 2^64
subtype 'Flag' => as 'Int' => where { $_ == 0 or $_ == 1 };
subtype 'YesNo' => as 'Str' => where { $_ eq 'Yes' or $_ eq 'No' };
subtype 'Timestamp' => as 'Str' => where { $_ eq '0000-00-00 00:00:00' or $_ =~ $TIMESTAMP_RE };
subtype 'Datetime' => as 'Str';
subtype 'Date' => as 'Str';
subtype 'String' => as 'Str';
subtype 'Varchar' => as 'Str';

foreach my $t (qw/Int Number UnsignedInt UnsignedNumber Flag YesNo Timestamp Datetime Date String Varchar Id Id64/) {
    subtype "NullOr$t"
        => as "Maybe[$t]";
}


foreach my $length ( qw/10 15 20 22 25 30 32 50 55 64 100 128 155 200 255 256 400 500 1000 1024 4000 4096/ ) {
    subtype "Varchar$length"
        => as 'Str'
        => where { length($_) <= $length };

    subtype "NullOrVarchar$length"
        => as 'Maybe[Str]'
        => where { !$_ || length($_) <= $length };
}

subtype "Md5Base64"
    => as 'Str'
    => where { length($_) <= 22 };

subtype "NullOrMd5Base64"
    => as 'Maybe[Str]'
    => where { !$_ || length($_) <= 22 };

1;
