package Model::Mapper::Link;

use strict;
use warnings;
use utf8;

use Yandex::DBTools;

use Mouse;

has [ qw/name right_mapper left_mapper to_model left_table left_key right_table right_key/ ]
    => (is => 'ro', isa => 'Str', required => 1);

# multi for has_many maybe for may_belongs_to (thats the case when parent
# object could be missed)
has [ qw/is_multi maybe/ ]
    => (is => 'ro', isa => 'Bool', default => 0);

sub full_right_key {
    my $self = shift;
    my $prefix = shift || $self->right_table;

    return $self->_table_column_quoted($prefix, $self->right_key);
}

sub full_left_key {
    my $self = shift;
    my $alias = shift;
    return $self->_table_column_quoted(
        ($alias || $self->left_table),
        $self->left_key)
}

sub _table_column_quoted {
    my ($self, $table, $column, $prefix) = @_;
    $prefix //= '';

    return
        $self->_quote_identifier( "$prefix$table" )
        . '.'
        . $self->_quote_identifier( $column );
}

sub sql_join {
    my $self = shift;
    my $prefix = shift || '';
    my $lk = $self->full_left_key($prefix);
    $prefix .= ':' if $prefix;
    my $table = $self->_quote_identifier($self->right_table);
    my $alias = $prefix . $self->name;
    my $alias_quoted = $self->_quote_identifier($prefix . $self->name);

    my $rk = $self->full_right_key($alias);

    my $left = $self->is_multi || $self->maybe ? 'LEFT ' : '';
    return " ${left}JOIN $table $alias_quoted ON $lk = $rk";
}

sub _quote_identifier {
    my $self = shift;
    return sql_quote_identifier(@_);
}

__PACKAGE__->meta->make_immutable();
