package Model::Mapper::Link::Factory;

use Module::Load;

use Model::Mapper::Link;

use Mouse;

has [qw/mapper_class field from/]
    => ( is => 'ro', isa => 'Str', required => 1 );

has [qw/by thru/]
    => ( is => 'ro', isa => 'Str' );

sub BUILD {
    my $self = shift;
    die "by or thru must be set"
        unless $self->by || $self->thru;

    die "only by or thru could be set"
        if $self->by && $self->thru;

    load $self->from;
}

sub may_has_one_link {
    my $self = shift;
    return $self->_link_new(
        $self->_has_params,
        maybe => 1,
    );
}

sub has_one_link {
    my $self = shift;
    return $self->_link_new(
        $self->_has_params
    );
}

sub has_many_link {
    my $self = shift;
    return $self->_link_new(
        $self->_has_params,
        is_multi => 1
    );
}

sub belongs_to_link {
    my $self = shift;
    return $self->_link_new(
        $self->_belongs_to_params
    );
}

sub may_belongs_to_link {
    my $self = shift;
    return $self->_link_new(
        $self->_belongs_to_params,
        maybe => 1,
    );
}

sub _link_new { shift and  Model::Mapper::Link->new(@_) }

sub _common_params {
    my $self = shift;
    return (
        name => $self->field,
        left_mapper => $self->mapper_class,
        right_mapper => $self->from,
        to_model => $self->_right_model_class_name,
        left_table => $self->_left_table_name,
        right_table => $self->_right_table_name,
    );
}

sub _has_params {
    my $self = shift;
    die "no by" unless $self->by;
    my $right_key = $self->from->fields_map->{$self->by}
        or die $self->from . ": column not found for field name: " . $self->by;
    return (
        $self->_common_params,
        left_key => $self->_left_table_id,
        right_key => $right_key
    );
}

sub _belongs_to_params {
    my $self = shift;
    die "no thru" unless $self->thru;
    my $left_key = $self->mapper_class->fields_map->{$self->thru}
        or die $self->mapper_class . ": table column not found for field name: " . $self->thru;
    return (
        $self->_common_params,
        left_key => $left_key,
        right_key => $self->_right_table_id
    );
}

sub _right_model_class_name {
    shift->from->_model_class_name;
}

sub _right_table_name {
    shift->from->_table_name
}

sub _right_table_id {
    shift->from->_table_id
}

sub _left_table_name {
    shift->mapper_class->_table_name
}

sub _left_table_id {
    shift->mapper_class->_table_id
}

1;
