package Model::Mapper::SQL;

use Model::Mapper::SQL::Query;

use Mouse;

extends 'Model::Mapper::SQL::Clonable';

has to_count_rows => ( is => 'rw', isa => 'Bool', default => 0);

sub count_rows {
    my $self = shift;
    $self->to_count_rows(1);
    return $self;
}

sub sql {
    my $self = shift;
    my %params = ( @_ );
    my ($where, $extra, $limit, $offset) = @params{qw/where extra limit offset/};

    my $select_sql = $self->SUPER::sql;

    my $has_many = grep { $_->is_multi } values %{$self->_links};

    if ($self->to_count_rows) {
        $select_sql =~ s/SELECT/SELECT SQL_CALC_FOUND_ROWS/i;
        warn "beware FOUND_ROWS will return rows count which is not the same as objects produced due to has many relationship" if $has_many;

    }
    my $query = Model::Mapper::SQL::Query->new($select_sql);

    if($where) {
        $query->append(WHERE => $where);
    }

    $query->append($extra) if $extra;

    if($limit || $offset) {
        $offset ||=  0;
        $query->append("LIMIT $offset, $limit");
        warn "Using offset/limit with aggregated (has_many) selects maybe not what you need since amount of objects in result might and mostly will not be the same as rows count"
            if $has_many;
    }

    return $query;
}


#no qoute for use in dbtools where => { .. }
sub map_field_to_sql_nq {
    my $self = shift;
    my $tc = shift;
    my $to_quote = (shift||0);
    my ($link_name, $field) = $self->_split_table_column($tc);
    my ($table, $column);
    if ($link_name) {
        my $link = $self->_links->{$link_name} or die "no link for $link_name when mapping $tc";
        $table = $link->right_table;
        $column = $link->right_mapper->fields_map->{$field};
    } else {
        $table = $self->mapper->_table_name;
        $column = $self->mapper->fields_map->{$tc};
    }
    $table = $self->_quote_identifier($table)
        if $to_quote;

    return "$table.$column";
}

sub map_field_to_sql {
    my ($self, $tc) = @_;
    return $self->map_field_to_sql_nq($tc, 1);
}

sub _split_table_column {
    my $self = shift;
    my $tc = shift;
    $tc =~ /^(.+?)\.(.+)$/;
    return ($1,$2);
}

__PACKAGE__->meta->make_immutable();
