package Model::Mapper::SQL::Query;

use strict;
use warnings;
use utf8;

use Yandex::DBTools;

use overload
    '""' => \&to_string,
    'cmp' => \&cmp;

sub new {
    my $class = shift;
    return bless [ @_ ], $class;
}

sub cmp {
    my ($self, $other) = @_;
    return ($self."") cmp ($other."");
}

sub to_string {
    my $self = shift;
    return join ' ', map {
        ref $_ ? $self->_condition($_) : $_
    } @$self;
}

sub append {
    my $self = shift;
    push @$self, @_;
}

sub arrayref {
    my $self = shift;
    return [ @$self ];
}

sub _condition {
    my $self = shift;
    return sql_condition(@_);
}

sub TO_JSON { shift . "" }

1;
