package Model::Scheme;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    Model::Scheme

=head1 SYNOPSIS

    package Model::Mapper::Scheme::Something;
    use Model::Scheme;

    define_scheme {
        model => 'Model::Something',

        to_model =>  {
            source_field => model_field,
            soure_link_field => ('SchemeName' || $sheme)
            source_link_field => [ 'model_link_name', 'SchemeName' ]
            ...
        }

        links => [
            link_field => [ 'one', $scheme ],
            link_fieldn => [ 'many', { model => 'Model::SomeOtherThing', to_model_map => { data_source_field => model_field } ]
            one => [ 'Model::SomeSingleChild', {  } ],
            many => [ 'Model::SomeChild', { } ],
            maybe_one => [ 'Model::SomeOtherSingleChild', {  } ],
            belongs_to => ['Model::SomeParent' , {} ],
            may_belongs_to => [ 'Model::SomePossibleParent', {} ]
        ]

    }
    define_to_model_map {
        some_id => id,
        some_text => text
    };

    define_links {
        some_other_object => 'Model::Mapper::Scheme::SomeOtherObject'
    }

    model 'Model::Something';

    1;

    package main;

    use Model::Mapper::Scheme::Something
    use Model::Factory;

    my $scheme = Model::Mapper::Scheme::Something->new();
    $scheme->to_field_map; # { some_id => id, some_text =>text }

    Model::Factory->build($scheme, $data);


=head1 DESCRIPTION

    desc

=head1 METHODS

=cut

1;

__END__
