package Model::Mappers; # mappers loading factory

use warnings;
use strict;
use utf8;

use Module::Load;

sub new {
    my ($class, $db) = @_;

    return bless {
        db => $db
    }, $class;
}

sub db { shift->{db} }

# $mappers = Model::Mappers->new($db);
# $mappers->get('Banners);
sub get {
    my $self = shift;
    my $mapper_name = shift;

    my $module_name = "Model::Mapper::$mapper_name";
    load $module_name;

    return $module_name->new($self->db);
}

1;
