package Model::RecordSet;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    Model::RecordSet

=head1 SYNOPSIS

    use Model::RecordSet;
    my $models = Model::RecordSet->new(@models_list);
    $models->first();
    $models->last();

    while(my $model = $models->next) {
        ..
    }

    $models->ids; # @list of ids
    $models->all === @models_list;
    $models->size === scalar @models_list;
    $models->is_empty; === ( scalar @models_list ? 0 : 1 );
    $models->fields('field_name') # ($model1->field_name, .., $modelN->field_name);
    $models->counter; # iterator for next()
    $models->flush_count; # sets count to 0

=head1 DESCRIPTION

    Класс реализующий работу со списком моделей, объект класса может
    использоваться как ссылка на обычный массив. Все списковые методы мапперов
    должны возвращать ответ в виде Model::RecordSet, это позволяет избежать
    путанницы, когда один методы возвращают список, а другие ссылку на массив

=head1 METHODS

=cut

my %COUNTERS;

sub new {
    my $class = shift;
    my $items = (ref $_[0] eq 'ARRAY' ? $_[0] : \@_ );
    my $self = bless $items, $class;
    $COUNTERS{$self} = 0;
    return $self;
}

sub all { @{ $_[0] } }
sub first { shift->[0] }
sub last { $_[0]->[ $#{ $_[0] } ] }
sub next {
    my $self = shift;
    return $self->[ $self->_tick ];
}

sub size { $#{ $_[0] } + 1 }
sub is_empty { !shift->size }

sub ids { map { $_->id } shift->all }

sub fields {
    my $self = shift;
    my $field_name = shift;;
    return map {
        $_->$field_name
    } $self->all;
}

sub counter { $COUNTERS{ shift() } }
sub _tick { $COUNTERS{ shift() }++ }
sub flush_counter { $COUNTERS{ shift() } = 0 }

1;

__END__
