package Models::AdGroup;

use strict;
use warnings;
use utf8;

use Model::Base;

define_types_fields (
    Id => ['id', 'campaign_id'],
    NullOrVarchar255 => [qw/name/],
    NullOrId => ['minus_words_id']
);

belongs_to campaign => 'Models::Campaign';
has_many banners => 'Models::Banner';
has_many keywords => 'Models::Keyword';
belongs_to minus_words => 'Models::MinusWords';


done;

1;
