package Models::Mappers::AdGroups;

use strict;
use warnings;
use utf8;

use Model::Mapper::Base;

define_columns {
    pid => 'id',
    group_name => 'name',
    cid => 'campaign_id',
    mw_id => 'minus_words_id',
};

model 'Models::AdGroup' => from 'phrases' => by 'pid';

belongs_to campaign => from 'Models::Mappers::Campaigns' => thru 'campaign_id';
has_many banners => by 'group_id' => from 'Models::Mappers::Banners';
has_many keywords => by 'group_id' => from 'Models::Mappers::Keywords';
may_belongs_to minus_words => from 'Models::Mappers::MinusWords' => thru 'minus_words_id';


1;

