package Models::Mappers::Addresses;

use strict;
use warnings;
use utf8;

use Model::Mapper::Base;

define_columns {
    aid => 'id',
    ClientID => 'client_id',
    map_id => 'map_id',
    map_id_auto => 'map_id_auto',
    metro => 'metro',
    address => 'address'
};

model 'Models::Address' => from 'addresses' => by 'aid';

belongs_to location_manual => from 'Models::Mappers::MapLocations' => thru 'map_id';
belongs_to location_auto => from 'Models::Mappers::MapLocations' => thru 'map_id_auto';

1;