package Models::Mappers::Banners;

use strict;
use warnings;
use utf8;

use Model::Mapper::Base;

define_columns {
    bid => 'id',
    pid => 'group_id',
    title => 'title',
    body => 'body',
    href => 'href',
    vcard_id => 'vcard_id',
};

model 'Models::Banner' => from 'banners' => by 'bid';


has_one image => by 'banner_id' => from 'Models::Mappers::AdImages';
belongs_to vcard => from 'Models::Mappers::VCards' => thru 'vcard_id';
belongs_to group => from 'Models::Mappers::AdGroups' => thru 'group_id';


1;

