package Models::Mappers::VCards;

use strict;
use warnings;
use utf8;

use Model::Mapper::Base;

define_columns {
    vcard_id => 'id',
    address_id => 'address_id',
    country => 'country',
    street => 'street',
    house => 'house'
};

model 'Models::VCard' => from 'vcards' => by 'vcard_id';
belongs_to address => from 'Models::Mappers::Addresses' => thru 'address_id';
has_one banner => by 'vcard_id' => from 'Models::Mappers::Banners';

1;
