use strict;
use warnings;

use Data::Dumper;
use Test::More;
use Test::Deep;

use Yandex::DBTools;

use Models::Banner;
use Models::Mappers::Banners;

use Settings;

my $banner = Models::Banner->new({
    id => 123,
});

my @banner_ids = (277684577, 277684581, 277684585, 277684590, 277684595, 277684597, 277684599, 277684603, 277684606, 277684601);
my $CID = 8021106; # lamodasem
my $db = PPC( cid => $CID );

my $banners_mapper = Models::Mappers::Banners->new($db);

$banners_mapper->select
    ->fields(qw/id title body href/);
my $banners = $banners_mapper->get_by_ids(@banner_ids);

my $raw_banners = get_all_sql($db, ["SELECT bid, title, body, href FROM banners",
                    WHERE => {bid => \@banner_ids}]);

cmp_deeply([sort map {$_->id} $banners->all], [sort map {$_->{bid}} @$raw_banners]);

my @banner_models = map {
    new Models::Banner({
        id => $_->{bid},
        title => $_->{title},
        body => $_->{body},
        href => $_->{href},
    })
} @$raw_banners;

cmp_deeply([sort {$a->id <=> $b->id} @$banners], [sort {$a->id <=> $b->id} @banner_models]);

done_testing;
