#!/usr/bin/perl -w

use strict;
use Test::More;
use Test::Exception;
use DDP;

use Models::Mappers::AdGroups;
use Models::Mappers::Campaigns;
use Model::Mapper::Link::Factory;

use Settings;

use utf8;
use open ':std' => ':utf8';
binmode STDERR, ":utf8";
binmode STDOUT, ":utf8";

my $factory = 'Model::Mapper::Link::Factory';

my %by = ( by => 'group_id' );
my %thru = ( thru => 'campaign_id' );

my %params = (
    mapper_class => 'Models::Mappers::AdGroups',
    field => 'banners',
    from => "Models::Mappers::Banners"
);

my %belongs_params = (
    mapper_class => 'Models::Mappers::AdGroups',
    field => 'campaign',
    from => 'Models::Mappers::Campaigns',
    %thru
);

dies_ok(sub { $factory->new }, 'no params dies');
dies_ok(sub { $factory->new(%params) }, 'no by or thru - dies');
dies_ok(sub { $factory->new(%params, %by, %thru) }, 'both by and thru - dies');
dies_ok(sub { $factory->new(%params, %thru)->has_one_link }, 'has_one link, but no by - dies');
dies_ok(sub { $factory->new(%params, %thru)->has_many_link }, 'has_many link, but no by - dies');
dies_ok(sub { $factory->new(%params, %by)->belongs_to_link}, 'belongs_to link, but no thru - dies');

my $link;
ok($link = $factory->new(%params, %by)->has_one_link, 'has_one link');
ok($link->sql_join eq ' JOIN `banners` `banners` ON `phrases`.`pid` = `banners`.`pid`', 'has one join');

ok($link = $factory->new(%params, %by)->has_many_link, 'has_many link');
ok($link->sql_join eq ' LEFT JOIN `banners` `banners` ON `phrases`.`pid` = `banners`.`pid`',
    'has many left join');

ok($link = $factory->new(%belongs_params)->belongs_to_link, 'belongs_to link');

ok($link->sql_join eq ' JOIN `campaigns` `campaign` ON `phrases`.`cid` = `campaign`.`cid`',
    'belongs to join');

done_testing;
