#!/usr/bin/perl -w

use strict;
use Test::More tests => 4;

use Models::Mappers::AdGroups;
use Settings;

use utf8;
use open ':std' => ':utf8';
binmode STDERR, ":utf8";
binmode STDOUT, ":utf8";

my $campaign_link = {
    'name' => 'campaign',
    'right_key' => 'cid',
    'right_mapper' => 'Models::Mappers::Campaigns',
    'left_mapper' => 'Models::Mappers::AdGroups',
    'to_model' => 'Models::Campaign',
    'left_key' => 'cid',
    'left_table' => 'phrases',
    'right_table' => 'campaigns',
    'is_multi' => 0,
    'maybe' => 0
};

my $banners_link = {
    'name' => 'banners',
    'right_key' => 'pid',
    'right_mapper' => 'Models::Mappers::Banners',
    'left_mapper' => 'Models::Mappers::AdGroups',
    'to_model' => 'Models::Banner',
    'left_key' => 'pid',
    'left_table' => 'phrases',
    'right_table' => 'banners',
    'is_multi' => 1,
    'maybe' => 0
};

my $keywords_link = {
    'name' => 'keywords',
    'right_key' => 'pid',
    'right_mapper' => 'Models::Mappers::Keywords',
    'left_mapper' => 'Models::Mappers::AdGroups',
    'to_model' => 'Models::Keyword',
    'left_key' => 'pid',
    'left_table' => 'phrases',
    'right_table' => 'bids',
    'is_multi' => 1,
    'maybe' => 0
};

my $minus_words_link = {
    'right_key' => 'mw_id',
    'right_mapper' => 'Models::Mappers::MinusWords',
    'left_mapper' => 'Models::Mappers::AdGroups',
    'name' => 'minus_words',
    'to_model' => 'Models::MinusWords',
    'left_key' => 'mw_id',
    'left_table' => 'phrases',
    'is_multi' => 0,
    'right_table' => 'minus_words',
    'maybe' => 1,
};


my $groups_mapper = Models::Mappers::AdGroups->new(PPC(shard => 1));
is_deeply($groups_mapper->campaign_link, $campaign_link);
is_deeply($groups_mapper->banners_link, $banners_link);
is_deeply($groups_mapper->keywords_link, $keywords_link);
is_deeply($groups_mapper->minus_words_link, $minus_words_link);


