use strict;
use warnings;
use utf8;

use Test::More tests => 2;
use Test::Deep;

use Data::Dumper;
use DDP;

use Yandex::DBTools;
use Settings;

use Models::Mappers::AdGroups;
use Models::Mappers::Banners;
use Model::DataTree::Compiler;

my $DEBUG = 0; #0;
my $CID = 8021106; # lamodasem
my $groups = [qw/258475080 258475080 258475080 258475089 258475089 258475089 258475089 258475089 258475089 258475097/];

my $db = PPC( cid => $CID );

my $adgroups_mapper = Models::Mappers::AdGroups->new($db);
$adgroups_mapper->select
    ->fields(qw/id name/)
    ->also(banners => Models::Mappers::Banners->new($db)
        ->select
        ->fields(qw/id title body href/)
        ->also(vcard => [qw/country street house/])
    )->also(keywords => [qw/id text/] );

if($DEBUG) {
    warn $adgroups_mapper->selector->sql . "\n";
    warn Dumper $adgroups_mapper->selector->conversion_map;
    warn Dumper $adgroups_mapper->selector->scheme_data;
}

my $raw_groups = get_all_sql($db, [$adgroups_mapper->selector->sql,
                    WHERE => { 'phrases.pid' => $groups }]);

my $compiler = Model::DataTree::Compiler->new(
    $adgroups_mapper->selector->scheme,
    $adgroups_mapper->selector->conversion_map
);

my $groups_data = $compiler->build($raw_groups);

my $adgroup_model = $adgroups_mapper->inflate(%{$groups_data->[0]});

is_deeply(
    $adgroups_mapper->get_by_ids(@$groups),
    $compiler->build( $raw_groups )
);
is_deeply( $adgroup_model->to_hash, $compiler->build( $raw_groups )->[0] );

if($DEBUG) {
    warn p $adgroups_mapper->get_by_ids(@$groups)->first;
}

1;
