use strict;
use warnings;

use Test::More tests => 14;
use Test::Exception;;
use DDP;

use Model::RecordSet;
use Models::Banner;

my $set = Model::RecordSet->new(qw/a b c d e f j h i g/);
my $set2 = Model::RecordSet->new([qw/a b c d e f j h i g/]);

is_deeply([$set->all], [$set2->all], 'sets from array and array ref are equal');
ok($set->size == 10, 'size');
ok($set->first eq 'a', 'first');
ok($set->last eq 'g', 'last');
ok(!$set->is_empty, 'non empty');
ok(Model::RecordSet->new->is_empty, 'is empty');

ok($set->next eq 'a', 'next');
ok($set->counter == 1, 'counter 1');

ok($set2->next eq 'a', 'other list next till a');
ok($set2->next eq 'b', 'next is b');

$set2->flush_counter;
ok($set2->next eq 'a', 'next is a again after flush');

my @banners;
foreach (1..5) {
    push @banners, Models::Banner->new(id => $_, title => "banner$_");
}

my $banners_set = Model::RecordSet->new(@banners);

ok($banners_set->size == 5, 'banners size');
is_deeply([ $banners_set->ids ], [qw/1 2 3 4 5/], "ids" );
is_deeply(
    [ $banners_set->fields('title') ],
    [qw/banner1 banner2 banner3 banner4 banner5/],
    "titles" );

#die $set->size;
