#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use lib::abs;

use File::Find;
use File::Slurp;
use TAP::Harness;

my $ROOT = lib::abs::path('../');
my $TESTS_DIR = lib::abs::path('./');

my @test_files;

if($ARGV[0]) {
    @test_files = (shift @ARGV)
} else {
    find(
        {
            wanted => sub {
                push @test_files, $File::Find::name if -f $_
            },
            preprocess => sub {
                return grep { -d || /\.(?:t)$/ } @_;
            },
        }, "$TESTS_DIR"
    ) unless @test_files;
}

map {s!^$ROOT/!!; $_} @test_files;

my $harness = TAP::Harness->new( {
    verbosity => 1,

    lib => [
        "$ROOT/lib",
        "$TESTS_DIR",
        '/var/www/ppc.yandex.ru/protected',
        '/var/www/ppc.yandex.ru/perl/rbac-elementary',
        '/var/www/ppc.yandex.ru/perl/settings',
    ],
});

# подозрительного вида хак для совместимости TAP::Harness и utf-ного вывода тестов
binmode(STDOUT, ':raw');
binmode(STDERR, ':raw');

my $agg = $harness->runtests(@test_files);
exit $agg->has_errors ? 1 : 0;

