package Direct::Modern;

use v5.14;

use strict;
use warnings;
use utf8;

use feature  ();

use Carp     ();

sub import {
    strict->import;
    warnings->import;
    utf8->import;
    feature->import(':5.14');

    # magic!
    Carp->export_to_level(1);
}

sub unimport {
    feature->unimport;
    utf8->unimport;
    warnings->unimport;
    strict->unimport;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Direct::Modern - подключить все обязательные прагмы и модули, необходимые для разработки Директа

=head1 SYNOPSIS

Данный модуль во время импорта автоматически подключает все необходимые прагмы и модули, рекомендуемые к
использованию в современном программировании на Perl.

Вызов:

    use Direct::Modern;

Аналогичен коду ниже:

    use strict;
    use warnings;
    use utf8;

    use v5.14;

    use Carp;

Модуль написан на основе Modern::Perl (L<http://search.cpan.org/dist/Modern-Perl/>)

=head1 AUTHOR

orlenko
