#!/usr/bin/perl

use warnings;
use strict;
use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Exception;

BEGIN { use_ok( 'Direct::PhraseTools' ); }

use utf8;
use open ':std' => ':utf8';

*kpft = \&Direct::PhraseTools::key_phrase_from_text;

is(kpft('матрас кровать'), 'матрас кровать', 'без стоп-слов');
is(kpft('матрас на кровать'), 'матрас +на кровать', 'есть стоп-слово');
is(kpft('"матрас на кровать"'), '"матрас на кровать"', 'есть стоп-слово, фраза в кавычках');
is(kpft('"матрас +на кровать"'), '"матрас на кровать"', 'есть стоп-слово с "+", фраза в кавычках');
is(kpft('[матрас на кровать]'), '[матрас +на кровать]', 'есть стоп-слово, фраза в []');
is(kpft('матрас кровать -для'), 'матрас кровать -для', 'есть минус-стоп-слово');

is(kpft('"матрас кровать'), '"матрас кровать', 'незакрытые кавычки');
is(kpft('матрас [~ кровать'), 'матрас [~ кровать', 'незакрытые квадратные скобки в середине');

done_testing();
