#!/usr/bin/perl

use warnings;
use strict;
use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Exception;

BEGIN { use_ok( 'Direct::PhraseTools' ); }

use utf8;
use open ':std' => ':utf8';

*mpft = \&Direct::PhraseTools::minus_phrase_from_text;

is(mpft('матрас кровать'), '"матрас кровать"', 'без стоп-слов');
is(mpft('матрас на кровать'), '"матрас на кровать"', 'есть стоп-слово');
is(mpft('"матрас на кровать"'), '"матрас на кровать"', 'есть стоп-слово, фраза в кавычках');
is(mpft('"матрас +на кровать"'), '"матрас на кровать"', 'есть стоп-слово с "+", фраза в кавычках');
is(mpft('[матрас на кровать]'), '[матрас +на кровать]', 'есть стоп-слово, фраза в []');
is(mpft('матрас кровать -трактор'), 'матрас кровать -трактор', 'есть минус-слово');
is(mpft('матрас кровать -для'), 'матрас кровать -для', 'есть минус-стоп-слово');

is(mpft('"матрас кровать'), '"матрас кровать', 'незакрытые кавычки');
is(mpft('матрас [~ кровать'), 'матрас [~ кровать', 'незакрытые квадратные скобки в середине');

done_testing();
