#!/usr/bin/perl

use warnings;
use strict;
use Test::More;

use Direct::PhraseTools qw/polish_phrase_text/;

use utf8;
use open ':std' => ':utf8';

my %test = (
    'раз два'        => 'раз два',
    ' раз два'       => 'раз два',
    ' раз  два '     => 'раз два',
    'раз +два'       => 'раз +два',
    '"раз два"'      => '"раз два"',
    '"+раз два"'     => '"раз два"',
    ' "+раз  +два" ' => '"раз два"',

    # "Плохие" фразы из одних чисел
    ' 666 '          => '666',
    ' 667 '          => '"667"',
    ' 666 667 '      => '"666 667"',
    ' "666"  '       => '"666"',
    ' 666 667'       => '"666 667"',
    ' 667 [туда-сюда]' => '667 [туда-сюда]',  # Нельзя брать в кавычки []
    ' 667 -никуда'  => '667 -никуда',         # Нельзя брать в кавычки минус-слова
    ' 667 привет' => '667 привет',            # Есть обычные слова
);

Test::More::plan(tests => scalar keys %test);

while (my ($in, $out) = each %test) {
    is(polish_phrase_text($in),$out);
}
