#!/usr/bin/perl

use warnings;
use strict;
use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Exception;

BEGIN { use_ok( 'Direct::PhraseTools' ); }

use utf8;
use open ':std' => ':utf8';

*swap = \&Direct::PhraseTools::stop_word_add_plus;
*swap_sm = sub {
    return Direct::PhraseTools::stop_word_add_plus(@_, skip_minus_words => 1);
};

is(swap('в далекое плавание'), '+в далекое плавание', 'стоп-слово в начале фразы');
is(swap('матрас на кровать'), 'матрас +на кровать', 'стоп-слово в середине фразы');
is(swap('проверяем стоп слово для'), 'проверяем стоп слово +для', 'стоп-слово в конце фразы');

is(swap('"матрас на кровать"'), '"матрас +на кровать"', 'стоп-слово в середине закавыченой фразы');
is(swap('"в далекое плавание"'), '"в далекое плавание"', 'стоп-слово в начале закавыченой фразы');
is(swap('"проверяем стоп слово для"'), '"проверяем стоп слово для"', 'стоп-слово в конце закавыченой фразы');

is(swap('[в далекое плавание]'), '[в далекое плавание]', 'стоп-слово в начале фразы в []');
is(swap('[проверяем стоп слово для]'), '[проверяем стоп слово для]', 'стоп-слово в конце фразы в []');

is(swap('матрас +на кровать'), 'матрас +на кровать', 'стоп-слово уже с "+"');
is(swap('матрас !на кровать'), 'матрас !на кровать', 'стоп-слово уже с "!"');

# некоторые тесты пропускаем, поскольку в таком контексте проверяемый метод не используется, 
# а для доведения до идеала и согласования/тестирования нужно время которого нет
# потому поведение оставляем "как есть"
# is(swap('матрас кровать -на'), 'матрас кровать -+на', 'минус стоп-слово');
# is(swap('матрас кровать -+на'), 'матрас кровать -+на', 'минус стоп-слово уже с "+"');
is(swap('матрас кровать -!на'), 'матрас кровать -!на', 'минус стоп-слово уже с "!"');

is(swap_sm('матрас кровать -на'), 'матрас кровать -на', 'минус стоп-слово, игнорируем минус-слова');
is(swap_sm('матрас кровать -+на'), 'матрас кровать -+на', 'минус стоп-слово уже с "+", игнорируем минус-слова');
is(swap_sm('матрас кровать -!на'), 'матрас кровать -!на', 'минус стоп-слово уже с "!", игнорируем минус-слова');

done_testing();
