#!/usr/bin/perl

use warnings;
use strict;
use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Exception;

BEGIN { use_ok( 'Direct::PhraseTools' ); }

use utf8;
use open ':std' => ':utf8';

*upfp = \&Direct::PhraseTools::unquoted_key_phrase_from_key_phrase;

is(upfp('матрас кровать'), 'матрас кровать', 'без стоп-слов, без кавычек');
is(upfp('матрас на кровать'), 'матрас на кровать', 'есть стоп-слово, без кавычек');
is(upfp('"матрас на кровать"'), 'матрас +на кровать', 'есть стоп-слово, фраза в кавычках');
is(upfp('"матрас +на кровать"'), 'матрас +на кровать', 'есть стоп-слово с "+", фраза в кавычках');
is(upfp('матрас кровать -трактор'), 'матрас кровать -трактор', 'есть минус-слово');

done_testing();
