#!/usr/bin/perl

use warnings;
use strict;
use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Exception;

BEGIN { use_ok( 'Direct::PhraseTools' ); }

use utf8;
use open ':std' => ':utf8';

*upft = \&Direct::PhraseTools::unquoted_key_phrase_from_text;

is(upft('матрас кровать'), 'матрас кровать', 'без стоп-слов, без кавычек');
is(upft('матрас на кровать'), 'матрас +на кровать', 'есть стоп-слово, без кавычек');
is(upft('"матрас на кровать"'), 'матрас +на кровать', 'есть стоп-слово, фраза в кавычках');
is(upft('"матрас +на кровать"'), 'матрас +на кровать', 'есть стоп-слово с "+", фраза в кавычках');
is(upft('матрас кровать -трактор'), 'матрас кровать -трактор', 'есть минус-слово');

is(upft('"матрас кровать'), '"матрас кровать', 'незакрытые кавычки');
is(upft('матрас [~ кровать'), 'матрас [~ кровать', 'незакрытые квадратные скобки в середине');

done_testing();
