package Yandex::ExecuteJS;

# $Id$

=head1 NAME

    Yandex::ExecuteJS

=head1 DESCRIPTION

    Обертка вокруг JavaScript или JavaScript::V8
    Загружаем js-код из файла, исполненяем, возвращаем результат

=cut

use strict;
use warnings;

use File::Slurp;
use JSON;

use base qw/Exporter/;
our @EXPORT = qw/call_js/;


{
    # в CX - уже готовые перловые функции-обвязки
    my %CX;
    my $write_sub = sub {print STDERR "js write: ", @_, "\n";};

sub call_js
{
    my ($js_file_name, $js_func, $args, %OPT) = @_;
    
    unless (defined $CX{$js_file_name} ){
        my $backend = _js_backend();
        my $js_text = read_file($js_file_name);
        if ($backend eq 'JavaScript') {
            my $rt = JavaScript::Runtime->new($OPT{js_maxbytes} ? $OPT{js_maxbytes} : ());
            my $cx = $rt->create_context(); 
            $cx->bind_function(write => $write_sub) if !$OPT{dont_js_write};
            if ($OPT{bind_functions}) {
                while (my($func_name, $func_sub) = each %{$OPT{bind_functions}}) {
                    $cx->bind_function($func_name => $func_sub);
                }
            }
            $cx->eval($js_text);
            $CX{$js_file_name} = sub {return $cx->call($js_func, @_);};
        } elsif ($backend eq 'JavaScript::V8') {
            my $cx = JavaScript::V8::Context->new();
            $cx->bind_function(write => $write_sub) if !$OPT{dont_js_write};
            if ($OPT{bind_functions}) {
                while (my($func_name, $func_sub) = each %{$OPT{bind_functions}}) {
                    $cx->bind_function($func_name => $func_sub);
                }
            }
            $cx->eval($js_text);
            $CX{$js_file_name} = sub {
                (my $js_args = encode_json(\@_)) =~ s/^\[|\]$//g;
                my $js_call_text = "$js_func($js_args)";
                return $cx->eval($js_call_text);
            };
        } else {
            die "Unsupported js backend: $backend";
        }
    }

    my $js_result = $CX{$js_file_name}->(@$args);

    return $js_result;
}

=head2 flush_context_cache

    Сбрасывает кеш JSных контекстов вместе со всеми связанными с ними объектами

    Yandex::ExecuteJS::flush_context_cache();
    Yandex::ExecuteJS::flush_context_cache($js_file_name);

=cut

sub flush_context_cache {
    my ($js_file_name) = @_;

    if ($js_file_name) {
        delete $CX{$js_file_name};
    } else {
        %CX = ();
    }
}

# загружаем один из доступных бекэндов выполнения JS-кода
sub _js_backend {
    eval { require JavaScript; };
    return 'JavaScript' if !$@;

    eval { require JavaScript::V8; };
    return 'JavaScript::V8' if !$@;

    die "No javascript backend available.";
}

}


1;

