#!/usr/bin/perl -w

use strict;
use File::Temp qw/tempfile/;
use File::Slurp;

use Test::More tests => 1;

use Yandex::ExecuteJS;

my (undef, $jsfile) = tempfile(UNLINK => 1);

my %bind_functions = (
    cccc => sub { return $_[0] + $_[1]->{test}; },
);
write_file($jsfile, 'function my_sum(a, b) {return a + b + cccc(a, {test : b})}');
is(call_js($jsfile, 'my_sum', [12, 23], bind_functions => \%bind_functions), 70, 'Simple sum with perl function call with object as an argument');
