use strict;
use warnings;

package Yandex::Hostname;

=head1 DESCRIPTION

    Определение хостнеймов, приспособленное к условиям Яндекса

    Ничего не экспортирует, чтобы было лучше понятно, что зовется именно наша функция:

    $fqdn = Yandex::Hostname::hostfqdn();

=cut

use Socket qw(getaddrinfo SOCK_DGRAM AI_CANONNAME);
use Sys::Hostname qw(hostname);


=head2 hostfqdn
 
    Реализация скопирована из switchman 2.00

=cut
sub hostfqdn
{
    my $sys_hname = hostname();
    my ($err, @res) = getaddrinfo($sys_hname, 0, {socktype => SOCK_DGRAM, flags => AI_CANONNAME});

    my $fqdn = (grep { $_ } map { $_->{canonname} } @res)[0];
    $fqdn ||= $sys_hname;

    die "Cannot determine fqdn" if !$fqdn;
    return $fqdn;
}


1;
