#!/usr/bin/perl -w

use strict;
use List::Util qw/max/;
use Test::More;

use Yandex::HighlightWords;
use Encode;

use utf8;
use open ':std' => ':utf8';

sub hi {
    my ($h_obj, $word) = @_;
    my $response =  $h_obj->highlight($word, {});

    return undef unless $response->{flag};
    return $response;
};

my %dict = (
    "Часы идут неверно" => undef
    , "Часов не наблюдаю" => "[Часов] не наблюдаю"
    , "11-12 часов" => "11-12 [часов]"
    , "гуляли в облаках" => "[гуляли] [в] [облаках]"
    , "я никогда не гулял в облаках" => undef
    , "+в контакте" => "+[в] [контакте]"
    , "+в +контакте" => "+[в] +[контакте]"
    , "+одноклассники" => "+[одноклассники]"
    , "в контакте" =>  "[в] [контакте]"
    , "одноклассники" => "[одноклассники]"
    , "получая финансовое раздражение в контакте" => "получая финансовое [раздражение] [в] [контакте]"
    , "!гулял в финансовое раздражение в контакте   " => "!гулял в финансовое [раздражение] [в] [контакте]   "
    , "кот лежит на столе и чешет за ухом" => "[кот] [лежит] [на] [столе] [и] [чешет] [за] [ухом]"
    , 'чешет за ухом' => '[чешет] [за] [ухом]'
    , 'чешет за чужим ухом' => undef
    , 'за ухом чешет' => undef,
    , "!XXX XXX YYY ZZZ" =>  "!XXX [XXX] [YYY] [ZZZ]"
    , 'моряк в море' => '[моряк] [в] [море]'
    , 'моряк один в море' => '[моряк] один [в] [море]'
    , 'хорошие цены на жилье в москве' => 'хорошие цены на жилье [в] [москве]'
    , 'хорошие цены голове моей на' => 'хорошие цены [голове] моей [на]'
);

Test::More::plan(tests => scalar( keys %dict ) + 1 );

my $h_obj = Yandex::HighlightWords->new({ phrases => ['!часов', '^гулял в облаках',  'стол', '^в контакте', '^одноклассники',
                                                      'раздражение в контакте', 'гулял в саду', '~море в моряке',
                                                     '!в !москве',
                                                      'кот лежит на столе и чешет за ухом', 'чешет за ухом', 'XXX YYY', 'YYY ZZZ',
                                                      '~!на !голове'
                                                     ],
                                          regexp_func => sub { return "[".$_[1]."]" }  });

while (my ($k, $v) = each %dict) {
    my $result = hi($h_obj, $k);
    is ($result->{text}, $v, 'Highlighted phrase: '.Encode::encode_utf8($k));
}


my $result = hi($h_obj, 'XXX YYY' );
is_deeply( $result->{names}, { 'hardcoded' => 1 }, "Wrong check for key 'names'" );
