#!/usr/bin/perl -w

use strict;
use List::Util qw/max/;
use Test::More tests => 1;

use Yandex::HighlightWords;

use utf8;
use open ':std' => ':utf8';
binmode(STDERR, ":utf8");
binmode(STDOUT, ":utf8");
use Yandex::Test::UTF8Builder;

my @phrases = map { join " ", map { join "", map {chr ( ord("а") + int rand(ord("я")-ord("а")) ) } 1..max(2,rand(6)) } 1..max(1, rand(5)) } 1..100; 

my $h = Yandex::HighlightWords->new({ phrases => [@phrases] });

ok(join(', ', $h->phrases_list) eq join(', ', sort @phrases), "phrases list works well");
