#! /usr/bin/perl

use strict;
use warnings;

use Test::More;

use Yandex::HTTP qw/http_parallel_request/;
use Test::HTTP::Server;

use File::Temp;
use Fcntl ':flock';

use JSON;
use Time::HiRes;
use List::MoreUtils qw/ any /;

our $DEBUG = 0;

our $filename = tmpnam();

# Запускаем тестовый http-сервер
sub Test::HTTP::Server::Request::test_request
{
    my ($self, @args) = @_;
    my $req_id = $args[0];
    my $attempt = _get_update_attempt_num($req_id);

    my $response = "response for $req_id, attempt $attempt [$$]\x0D\x0A";

    if ($attempt == 0) {
        sleep 1;
        $self->{out_code} = "502 Bad Gateway";
    }

    return $response;
}

my $server = Test::HTTP::Server->new();


=pod
хитрый случай: 
- первый запрос тормозит
- софт-таймаутный запрос не успевает отработать (не достаточно слотов)
- приходит ошибка по первому запросу - мы говорим что всё плохо и отменяем soft-перезапрос
=cut
my $result = http_parallel_request(
    "GET", 
    {
        1 => { url => $server->uri() . "test_request/1" },
    },
    max_req => 1,
    timeout => 60,
    num_attempts => 2,
    soft_timeout => 0.5,
);

ok($result->{1}->{is_success});

done_testing();


sub _get_update_attempt_num {
    my ($id) = @_;

    open my $file, '+>>', $filename;
    flock $file, LOCK_EX;
    sysseek $file, 0, 0;
    sysread $file, my $buf, 1000;

    my $values = decode_json( $buf || '[]' );
    my $result = $values->[$id] || 0;
    $values->[$id] = $result + 1;
    $buf = encode_json( $values );

    sysseek $file, 0, 0;
    truncate $file, 0;
    syswrite $file, $buf;

    close $file;

    return $result;
}



