#! /usr/bin/perl

=head1 connect_timeout.t

    Тест проверяет работоспособность опции connect_timeout

=cut

use strict;
use Time::HiRes qw/time sleep/;
use Test::More;
use Data::Dumper;
use Test::HTTP::Server;

use Yandex::HTTP qw/http_parallel_request/;

my $resp;

$resp = http_parallel_request("GET", {1 => {url => "http://direct.yandex.ru:22/"}}, timeout => 3, connect_timeout => 0.5)->{1};
like($resp->{headers}->{Status}, qr/^59[59]/, "status 59x");
cmp_ok($resp->{elapsed}, '<', 0.6, 'valid elapsed');
cmp_ok($resp->{elapsed}, '>', 0.4, 'valid elapsed');



# Запускаем тестовый http-сервер
my $server = Test::HTTP::Server->new();
sub Test::HTTP::Server::Request::test
{
    sleep 0.5;
    return "test";
}

$resp = http_parallel_request("GET", {1 => {url => $server->uri."test"}}, timeout => 1, connect_timeout => 0.1)->{1};
ok($resp->{is_success}, "success sleep req");
is($resp->{content}, "test", "correct req content");
cmp_ok($resp->{elapsed}, '>=', 0.5, 'correct sleep time');

done_testing();
