#! /usr/bin/perl

use strict;
use Test::More;
use Test::HTTP::Server;
use HTTP::Headers;

use Yandex::HTTP qw/http_get/;

my $server = Test::HTTP::Server->new();

my $res = http_get($server->uri."echo", headers => { 'X-Test' => 42 });

ok(_header_from_str($res,'X-Test') == 42);

my $h = HTTP::Headers->new('X-Test-Existing' => '666');
$res = http_get($server->uri."echo", default_headers => $h, headers => { 'X-Test' => 42 });
ok(_header_from_str($res, 'X-Test-Existing') == 666);
ok(_header_from_str($res, 'X-Test') == 42);

done_testing();

sub _header_from_str
{
    my $str = shift;
    my $h = shift;
    my $headers = HTTP::Headers->new(map { split /: / } grep { /: / } split /\r\n/, $str);
    return $headers->header($h);
}

