#!/usr/bin/perl -w

use strict;
use Test::More;

use Yandex::HTTP;

my @tests = (
    {
        data => ['direct.yandex.ru', {login => 'asdf', sum => 3}], 
        result => 'direct.yandex.ru?login=asdf&sum=3',
    },
    {
        data => ['direct.yandex.ru', [login => 'asdf', login => 'zxcv']],
        result => 'direct.yandex.ru?login=asdf&login=zxcv',
    },
    {
        data => ['direct.yandex.ru?login=asdf', {sum => 3}],
        result => 'direct.yandex.ru?login=asdf&sum=3',
    },
    {
        data => ['', {login => 'asdf', sum => 3}],
        result => 'login=asdf&sum=3',
    },
);


Test::More::plan(tests => 1 * @tests);

for my $i (0 .. scalar(@tests) - 1) {
    my $t = $tests[$i];
    my ($url, $form) = @{$t->{data}};
    is(Yandex::HTTP::make_url($url, $form), $t->{result}, "test #$i");
}

