#! /usr/bin/perl

=head1 

    Если колбэк падает - мы повторяем запрос

=cut

use strict;
use warnings;

use Time::HiRes qw/time sleep/;
use Test::More;
use Test::HTTP::Server;
use utf8;

use Yandex::HTTP qw/http_parallel_request/;

sub Test::HTTP::Server::Request::test
{
    my $self = shift;
    return $self->{body};
}

# Запускаем тестовый http-сервер
my $server = Test::HTTP::Server->new();

sub _req {
    my ($fails, $num_attempts, $max_total_retries) = @_;

    return http_parallel_request(
        POST => {
            1 => {url => $server->uri."test", body => "1"},
            2 => {url => $server->uri."test", body => "2"},
        }, 
        timeout => 1, 
        connect_timeout => 0.1,
        num_attempts => $num_attempts,
        max_total_retries => $max_total_retries,
        callback => sub {
            if ($fails --> 0) { die; }
        }
        );
}


my $resp;
sub resp_failed($) {
    my $resp = shift;
    return scalar grep {$_->{callback_error}} values %$resp;
}

$resp = _req(0, 1, 0);
ok(! resp_failed($resp), "no fails - good");

$resp = _req(1, 2, 1);
ok(! resp_failed($resp), "one fail - good");

$resp = _req(2, 5, 2);
ok(! resp_failed($resp), "two fails and enougth max_total_retries");

$resp = _req(2, 5, 1);
ok(resp_failed($resp), "two fails and not enougth max_total_retries");

done_testing();
