#! /usr/bin/perl

=head1 memory_leak.t

    Тест проверяет, что http_parallel_request не утекает памятью. 

=cut

use strict;
use Test::More tests => 2;

use Yandex::HTTP qw/http_parallel_request/;
use Yandex::ProcInfo;
use Test::HTTP::Server;

our $DEBUG = 0;

# количество итераций
my $iterations = 200;
# количество заданий (url'ов) в одном запросе
my $task_cnt = 50;

# Запускаем тестовый http-сервер
my $server = Test::HTTP::Server->new();
sub Test::HTTP::Server::Request::test_request
{
    my $self = shift;

    # todo: поменять на детерминированный порядок
    my $case = int(rand 10);
    if ( $case == 0 ) {
        # error
        return undef;
    }
    elsif ( $case == 1 ) {
        # timeout
        sleep 0.3;
    }
    return "test " x 100;
}
my $url = $server->uri . "test_request";

# Собираем задания для загрузки
my $tasks = {};
for my $k (1 .. $task_cnt){
    $tasks->{$k} = {
        url => $url,
    };
}

# Запрашиваем страницы и считаем память
my $size0 = int(proc_memory() / 1024 / 1024);
http_parallel_request("GET", $tasks, max_req => 5, timeout => 5, num_attempts => 2, soft_timeout => 0.5);
my $size1 = int(proc_memory() / 1024 / 1024);

# проверяем рост памяти после первого запроса
# в версии 0.13 изменено 3 на 4 поскольку рост вызван новой версией AnyEvent и AnyEvent::HTTP
ok($size1 - $size0 <= 4, "mem growth after the first request (Mb): $size0 --> $size1");

for my $i (0 .. $iterations) {
    if ( $DEBUG ) {
        my $size = int(proc_memory() / 1024 / 1024);
        print "iteration $i\t$size Mb\n" if  $i % 10 == 0;
    }

    http_parallel_request("GET", $tasks, max_req => 20, timeout => 5, num_attempts => 2, soft_timeout => 0.1);
}

my $sizeN = int(proc_memory() / 1024 / 1024);

# проверяем рост памяти после всех итераций
ok($sizeN - $size1 <= 1, "mem growth after $iterations iterations (Mb): $size1 --> $sizeN");


