#! /usr/bin/perl

use strict;
use Test::More;
use Test::HTTP::Server;
use HTTP::Headers;
use Test::Deep;

use Yandex::HTTP qw/http_parallel_request/;

my $server = Test::HTTP::Server->new();

my $i = 1;
my $res = http_parallel_request('GET', { 1 => { url => $server->uri."echo" }, 2 => { url => $server->uri."echo" } }, prepare_callback => sub {
    my $p = shift;
    $p->{headers}->{'X-Test'} = $i++;
});


my @expected_headers = keys %$res;
my @actual_headers = map { _header_from_str($_->{content}, 'X-Test') } values %$res;
cmp_bag(\@actual_headers, \@expected_headers);

done_testing();

sub _header_from_str
{
    my $str = shift;
    my $h = shift;
    my $headers = HTTP::Headers->new(map { split /: / } grep { /: / } split /\r\n/, $str);
    return $headers->header($h);
}
