#! /usr/bin/perl

=head1 connect_timeout.t

    Тест проверяет работоспособность опции response_size_limit

=cut

use strict;
use Time::HiRes qw/time sleep/;
use Test::More;
use Test::HTTP::Server;

use Yandex::HTTP qw/http_parallel_request/;

my $resp;

# Запускаем тестовый http-сервер
my $server = Test::HTTP::Server->new();
sub Test::HTTP::Server::Request::test
{
    return "1234567890" x 10_000; # 100_000 байт
}

sub Test::HTTP::Server::Request::test_empty
{
    return '';
}

sub Test::HTTP::Server::Request::test_zero
{
    return 0;
}

$resp = http_parallel_request("GET", {1 => {url => $server->uri."test"}})->{1};
ok($resp->{is_success}, "success 100_000 byte");
is($resp->{content}, "1234567890" x 10_000, "correct req content");

$resp = http_parallel_request("GET", {1 => {url => $server->uri."test"}}, response_size_limit => 150_000)->{1};
ok($resp->{is_success}, "success 100_000 byte with limit");
is($resp->{content}, "1234567890" x 10_000, "correct req with limit content");

$resp = http_parallel_request("GET", {1 => {url => $server->uri."test"}}, response_size_limit => 10_000)->{1};
ok(!$resp->{is_success}, "correct abort of request with limit");
ok(!defined $resp->{content}, "correct req with limit content (undef when aborted)");

$resp = http_parallel_request("GET", {1 => {url => $server->uri."test_zero"}}, response_size_limit => 10_000)->{1};
ok($resp->{is_success}, "success of zero request with limit");
ok(defined $resp->{content} && $resp->{content} == 0, "correct zero req with limit content");

done_testing();
